# LuminWave DS SDK V0.0.6.0 

[TOC]

---

## 启动前准备
* 初次启动时，请设置外部主机IP为默认地址 ***192.168.137.100***，设备在连接后向此地址发送数据，建立设备连接后，可使用SDK修改此地址
* 设备的默认地址为 ***192.168.137.200*** ，建立设备连接后，可使用SDK修改此地址
* 使用对应的电源适配器进行供电
* 建议使用千兆网线连接设备和外部主机

---

## SDK使用
### 数据接收启停
1. 使用 **LWDSStartReceiveData** 设置本地监听端口,开始接收数据 ***注意!这个操作通常仅需要调用一次,和 LWDSStopReceiveData 成对使用***
2. 需要停止数据接收时,使用函数 **LWDSStopReceiveData**,停止数据接收

### 设备连接
1. 使用 **LWDSConnectDevice** 函数，连接设备，默认设备地址为 ***192.168.137.200***, 默认端口号为 ***6001*** 
2. 连接成功后，即开始采集，子线程中完成相关作业
3. 需要停止时，调用 **LWDSDisconnectDevice** 函数,断开设备连接

* 当指定IP的设备已经存在时,操作仍然成功,但是仅修改设备的端口信息
* 设备连接成功后,被注册为一个 **设备对象**
* 部分函数执行时,会检索当前的 **设备对象**,判断设备是否存在,不存在则无法执行

### 数据采集(注册回调函数)
* 使用接口 **LWDSRegisterCallbackUpdateFrame** 注册指定IP设备的回调函数，用以更新单帧数据
* 使用接口 **LWDSRegisterCallbackUpdateImu** 注册指定IP设备的回调函数，用以更新IMU数据
* 这一步操作会检查是否存在IP对应的设备
* 没有找到指定IP对应的设备: ***LWDS_RETURN_DO_NOT_FIND_DEVICE***
* 注册成功时,返回: ***LWDS_RETURN_OK***
* 注册错误时,返回: ***LWDS_RETURN_REGISTER_FUNCTION_ERROR***

### 数据采集(主动采集)
* 使用 **LWDSGetFrame(deviceIp, LWDSFrameData)** 函数,主动采集指定设备的数据
* 通过返回码来判断当前的采集结果
* 没有找到指定IP对应的设备: ***LWDS_RETURN_DO_NOT_FIND_DEVICE***
* 获取成功时,返回: ***LWDS_RETURN_OK***
* 获取错误时,返回: ***LWDS_RETURN_GET_DATA_ERROR***

### 设备网络信息读取
* 使用接口 **LWDSGetNetInfo**,读取当前设备的网络信息,参数依次为:
1. 当前设备IP
2. 超时时间
3. 网络信息结构体指针,用于保存读取结果

* 读取失败时,返回: ***LWDS_RETURN_GET_ADDR_ERROR***
* 获取成功时,返回: ***LWDS_RETURN_OK***

### 设备网络信息设置
* 使用接口 **LWDSSetNetInfo**,设置当前设备的网络信息,参数依次为:
1. 当前设备IP
2. 超时时间
3. 网络信息结构体,保存要更改的设备网络信息

* 设置失败时,返回: ***LWDS_RETURN_SET_ADDR_ERROR***
* 设置成功时,返回: ***LWDS_RETURN_OK***

### 其他功能
请参考头文件 **LWDSApi.h** 中的函数说明

---

## 目录结构
### 主目录
* **main.cpp** : 包括了当前的几种数据采集方式的示例
* **CmakeList.txt** : 负责构建SDK示例软件

### include
* **LWDSType.h** : 类型定义头文件 
* **LWDSApi.h** : API声明头文件

### Linux64
* **libds_c_sdk.so** : LinuxX64环境下的库文件

### Arm64
* **libds_c_sdk.so** : Arm64(Arch64)环境下的库文件


---

## 更新日志
### V0.0.6.0
* 头文件中添加了状态码的打印函数,该函数允许根据需要客制化
* 优化飞点滤波功能
* 修复Linux下,网络信息读取异常的问题
* 添加了额外的函数说明以及更加详细的开发样例
* 降低当前的Arm下的编译版本到gcc-linaro-7.5 以提升库的兼容性

### V0.0.5.0
* 添加了多设备情况下的调度方案
* 添加了点云的飞点滤波功能
* 更改了部分旧的API 具体的使用方式请参考Demo示例

### V0.0.4.0
* 优化了CPU的高占用问题
* 添加了点云旋转API

### V0.0.3.0
* 优化了测角算法，修正部分计算流程
* 调整了算法参数的返回值，用返回码和日志信息来精确定位异常状态

### V0.0.2.0
* 添加对应的数据获取Api、算法设置Api
* 添加设备IP、主机IP修改的功能
* 修复了一处跨平台问题

### V0.0.1.0
* 初版发布，仅包含点云数据采集、IMU数据采集功能
